var serverSystem = server.registerSystem(0, 0);

// Setup which events to listen for
serverSystem.initialize = function () {

  //query to get all players
  this.playerQuery = this.registerQuery();

  this.listenForEvent("minecraft:block_destruction_started", eventData => this.onBlockDestructionStarted(eventData));
};

// per-tick updates
serverSystem.update = function () {
  // Any logic that needs to happen every tick on the server.
};

serverSystem.chat = function(message){
    const eventData = this.createEventData("minecraft:display_chat_event");
    eventData.data.message = message;
    this.broadcastEvent("minecraft:display_chat_event", eventData);
};

serverSystem.onBlockDestructionStarted = function (eventData) {
  this.chat("onBlockDestructionStarted");
  //get the first player
  let player = this.getPlayers()[0];

  if (player) {
    //get the first player's ticking area
    let tickingArea = this.getComponent(player, "minecraft:tick_world").data.ticking_area;
    let position = this.getComponent(player, "minecraft:position").data;

    //distance around the player for which to get blocks
    let distance = 1;

    //get blocks in an area
    let blocks = this.getBlocks(tickingArea, position.x - distance, position.y - distance, position.z - distance, position.x + distance, position.y + distance, position.z + distance);

    for (bx = 0; bx < blocks.length; bx++) {
      for (by = 0; by < blocks[bx].length; by++) {
        for (bz = 0; bz < blocks[by].length; bz++) {
          let block = blocks[bx][by][bz];
          let blockstates = this.getComponent(block, "minecraft:blockstate");

          //this.chat("Block: " + block.__identifier__);
          
          if (block.__identifier__ == "minecraft:redstone_wire") {
              
            //set redstone_signal to 100
            blockstates.data.redstone_signal = 100;
            this.applyComponentChanges(block, blockstates);
            
            if(blockstates.data !== null){
                for(key in blockstates.data){
                    this.chat(key + ": " + blockstates.data[key]);
                }
            }
          }
        }
      }
    }
  }
};

//returns an array of all players
serverSystem.getPlayers = function () {
  //run query to pull all entities and filter by player
  var players = this.getEntitiesFromQuery(this.playerQuery).filter(ent => ent.__identifier__ == "minecraft:player");

  return players;
};
